function Component() {

}

Component.prototype.createOperations = function() {
    component.createOperations();

    if (installer.isInstaller()) {
        if (systemInfo.productType === "windows") {

            // Try to kill app process at installation and uninstallation as well
			component.addOperation("KillProcess",
                // "cmd", // can be skipped
                "LaCie RAID Manager.exe");

            component.addOperation("CreateShortcut",
                "@TargetDir@/LaCie RAID Manager.exe",
                "@StartMenuDir@/LaCie RAID Manager.lnk",
                "workingDirectory=@TargetDir@");

            component.addOperation("CreateShortcut",
                "@TargetDir@/@MaintenanceToolName@.exe",
                "@StartMenuDir@/@MaintenanceToolName@.lnk",
                "workingDirectory=@TargetDir@");

            component.addOperation("CreateShortcut",
                "@TargetDir@/LaCie RAID Manager.exe",
                "@DesktopDir@/LaCie RAID Manager.lnk",
                "workingDirectory=@TargetDir@");

            // only install c runtime if it is needed, no minor version check of the c runtime till we need it
            // return value 3010 means it need a reboot, but in most cases it is not needed for run Qt application
            // return value 5100 means there's a newer version of the runtime already installed
            if (systemInfo.currentCpuArchitecture === "x86_64") {
                if (installer.value("HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Microsoft\\VisualStudio\\14.0\\VC\Runtimes\\x86\\Installed") != 1) {
                    component.addElevatedOperation("Execute", "{0,1638,3010,5100}", "@TargetDir@\\vcredist_2015_x86.exe", "/norestart", "/q");
                }
            } else if (systemInfo.currentCpuArchitecture === "i386") {
                if (installer.value("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\VisualStudio\\14.0\\VC\Runtimes\\x86\\Installed") != 1) {
                    component.addElevatedOperation("Execute", "{0,1638,3010,5100}", "@TargetDir@\\vcredist_2015_x86.exe", "/norestart", "/q");
                }
            }

            // Create autorun key in windows reg
            // component.addOperation("GlobalConfig",
            //    "HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run",
            //    "LaCie RAID Manager",
            //    "\"@TargetDir@\\LaCie RAID Manager.exe\"");

			component.addOperation("AutorunRegister",
                "@TargetDir@/LaCie RAID Manager.exe",
                "LaCie RAID Manager");

            var WINDIR = installer.environmentVariable("WINDIR");
            if (WINDIR != "") {
                /*
                	I believe your program is 32-bit and running under 64-bit Windows. 
                	PnPUtil.exe is not in c:\windows\system32 when you are running a 32-bit program, that's why QProcess fails to start it. 
                	It's somewhere else, for example, mine is located at 
                	C:\Windows\WinSxS\amd64_microsoft-windows-pnputil_31bf3856ad364e35_6.3.9600.16384_none_ee22229c907e8ce2. 
                	You can run c:\windows\system32\PnPUtil.exe in Command Prompt because cmd.exe is a 64-bit program.
                */

                var removeDriverBatchFile = "@TargetDir@/Drivers/RemoveDriver.bat";
                var cmdExecutable = ""
                var pnpUtilExecutable = ""
                if (systemInfo.currentCpuArchitecture === "x86_64") {
                    cmdExecutable = WINDIR + "/sysnative/cmd.exe";
                    pnpUtilExecutable = WINDIR + "/sysnative/PnPutil.exe";
                } else if (systemInfo.currentCpuArchitecture === "i386") {
                    cmdExecutable = WINDIR + "/system32/cmd.exe"
                    pnpUtilExecutable = WINDIR + "/system32/PnPutil.exe"
                }

                var devConExecutable = ""
                var infFile = ""
                if (systemInfo.productVersion === "7" || systemInfo.productVersion === "8" || systemInfo.productVersion === "8.1") {
                    if (systemInfo.currentCpuArchitecture === "x86_64") {
                        devConExecutable = "@TargetDir@/Drivers/1.1.3.1622_WIN7_8_WHQL/amd64/devcon.exe"
                        infFile = "@TargetDir@/Drivers/1.1.3.1622_WIN7_8_WHQL/amd64/*.inf"
                    } else if (systemInfo.currentCpuArchitecture === "i386") {
                        devConExecutable = "@TargetDir@/Drivers/1.1.3.1622_WIN7_8_WHQL/i386/devcon.exe"
                        infFile = "@TargetDir@/Drivers/1.1.3.1622_WIN7_8_WHQL/i386/*.inf"
                    }
                } else if (systemInfo.productVersion === "10" || systemInfo.productVersion === "10.0") {
                    if (systemInfo.currentCpuArchitecture === "x86_64") {
                        devConExecutable = "@TargetDir@/Drivers/1.1.3.1622_WIN10_WHQL/amd64/devcon.exe"
                        infFile = "@TargetDir@/Drivers/1.1.3.1622_WIN10_WHQL/amd64/*.inf"
                    } else if (systemInfo.currentCpuArchitecture === "i386") {
                        devConExecutable = "@TargetDir@/Drivers/1.1.3.1622_WIN10_WHQL/i386/devcon.exe"
                        infFile = "@TargetDir@/Drivers/1.1.3.1622_WIN10_WHQL/i386/*.inf"
                    }
                }

                // Silent driver installation
                var allowedErrorCodes = "{0,1,2,3,256,259}";
                component.addElevatedOperation("Execute", [allowedErrorCodes,
                    pnpUtilExecutable,
                    "/i", "/a", infFile,
                    "UNDOEXECUTE",
                    cmdExecutable, "/C", removeDriverBatchFile
                ]);

                // Start PnP update
                component.addOperation("Execute", devConExecutable, "rescan");
            }

            // Try to stop schedule service
            component.addElevatedOperation("Execute", "@TargetDir@/lcss.exe", "-stop");
            component.addElevatedOperation("Execute", "@TargetDir@/lcss.exe", "-remove");

            // Restart schedule service
            component.addElevatedOperation("Execute", "@TargetDir@/lcss.exe", "-install", "UNDOEXECUTE", "@TargetDir@/lcss.exe", "-remove");
            component.addElevatedOperation("Execute", "@TargetDir@/lcss.exe", "-start", "UNDOEXECUTE", "@TargetDir@/lcss.exe", "-stop");
        }
    }
}